import sys
import os
import jarray
import dircache
from java.io import File
from java.lang import String
 
myPropertyFile = "workManagerProperties.properties"
 
#=======================================================================================
# connection() Definition
#=======================================================================================
def connection():
    print '===> Connecting as '+ username + ' To WebLogic URL ' + url + '...'
    try:
        connect(username, password, url)
    except WLSTException:
        print '==> Error Connecting to The URL ' + url
        CancelEdit('y')
        exit()
 
print '==== Exiting Because Of Connectivity Error ===='
#=======================================================================================
print '======= Reading Property File and Connecting to Server ========'
loadProperties(myPropertyFile)
url=protocol + '://' + host + ':' + AdminPort
connection()
 
edit()
startEdit()
print '======= Creating a WorkManager name as ======='
cd('edit:/SelfTuning/' + domainName + '/WorkManagers/')
create(workManagerName,'WorkManagers')
cd('edit:/SelfTuning/' + domainName + '/WorkManagers/' + workManagerName)
cmo.addTarget(getMBean("/Clusters/"+ ClusterName))
#cd('edit:/SelfTuning/' + domainName + '/WorkManagers/' + workManagerName)
#set('JNDIName', jndiName)
save()
print ' WorkManager Created...'
 
print '======= Creating MaxThreadsConstraint ======='
cd('edit:/SelfTuning/' + domainName + '/MaxThreadsConstraints/')
try:
    create(maxThreadConstraintName,'MaxThreadsConstraints')
except Exception:
    print 'Issue in Creating MaxThreads exiting'
cd('edit:/SelfTuning/' + domainName + '/MaxThreadsConstraints/' + maxThreadConstraintName)
cmo.addTarget(getMBean("/Clusters/"+ ClusterName))
set('Count',MaxThread)
save()
 
print '======= Creating MinThreadsConstraint ======='
cd('edit:/SelfTuning/' + domainName + '/MinThreadsConstraints/')
try:
    create(minThreadConstraintName,'MinThreadsConstraints')
except Exception:
    print 'Issue In Creating MinThreads '
cd('edit:/SelfTuning/' + domainName + '/MinThreadsConstraints/' + minThreadConstraintName)
cmo.addTarget(getMBean("/Clusters/"+ ClusterName))
set('Count',MinThread)
save()
 
print '======= Assigning the MaxThreadConstraint to the WorkManager ======='
cd('edit:/SelfTuning/' + domainName + '/WorkManagers/' + workManagerName)
bean=getMBean('/SelfTuning/' + domainName + '/MaxThreadsConstraints/' + maxThreadConstraintName)
cmo.setMaxThreadsConstraint(bean)
 
print '======= Assigning the MinThreadConstraint to the WorkManager ======='
cd('edit:/SelfTuning/' + domainName + '/WorkManagers/' + workManagerName)
bean=getMBean('/SelfTuning/' + domainName + '/MinThreadsConstraints/' + minThreadConstraintName)
cmo.setMinThreadsConstraint(bean)
 
save()
activate(block="true")
print '==> WorkManager Creation Finished ... Please Double Check from AdminConsole...'
disconnect()